var openInfoWindow = null;

$(document).ready(function(){
		
	
});

viewerInit();

function viewerInit()
{
	jmolInitialize("./2.0/js/jmol-13.0.15/", false);
	jmolApplet([858, 600]);
		
	var molecule = $("#computed_molecule").val().replace("\n", '\n\n') 
	
	setTimeout(function() { 
		jmolLoadInline(molecule); 
	 	jmolScriptWait("set axes molecular;"); // setta l'origine degli assi all'atomo 0 0 0 della molecola
		jmolScriptWait("set axesmode 1;");
		jmolScriptWait("set axescale 2.0;");
		jmolScriptWait("set showAxes TRUE;"); // mostra gli assi
		jmolScriptWait("hide hydrogens;"); // mostra gli assi
	}, 800);	
}

function menuAction(menuItem){
	
	var prevOpenInfoWindow = openInfoWindow; 
	
	switch(menuItem)
	{
		case 1 : openInfoWindow = $('#file-wrap');         break;
		case 2 : openInfoWindow = $('#preview-wrap');      break;
		case 3 : openInfoWindow = $('#atom-radius-wrap');  break;
		case 4 : openInfoWindow = $('#about-wrap');        break; 
	}
	
	if(prevOpenInfoWindow != null && prevOpenInfoWindow[0].id == openInfoWindow[0].id)
	{	
		openInfoWindow.slideUp();
		openInfoWindow = null;
	}
	else
	{
		if(prevOpenInfoWindow != null)
			prevOpenInfoWindow.hide({
				'complete' : function(){openInfoWindow.slideDown();} 
			});	
		else
			openInfoWindow.slideDown();
	}
		
	return false;
	
}

function drawPoint()
{
	var z_constant = 0;
	
	$.ajax({
		type: "POST", 
		url: "./2.0/php/readDots.php",
		data: "",
		success: function (result) {
			
			//console.log(result);
			result = result.trim();
			var points = result.split('\n');
			
			for(i=0; i<points.length; i++)
			{
				points[i] = points[i].trim();
				var point = points[i].match(/[-]?[0-9]*[.][0-9]+/g);
				
				point[2] = point[2] * -1;
				
				if(i==0) z_constant = point[2];
				
				if(point[2] != z_constant)
				{
					color = createColor(point[2]);
					jmolScriptWait("draw point_"+i+" CIRCLE {"+ point.join(" ") +"} SCALE 5 COLOR ["+color[0]+","+color[1]+","+color[2]+"];");
					//pointInterpolation(points[i], points[i+1], z_constant, i);
				}
			}
			
		},
		error: function (result) {
			alert('Errore : ' + result.statusText);
		}
	});
}

function drawPointInterpolate()
{
	var z_constant = 0;
	
	$.ajax({
		type: "POST", 
		url: "./2.0/php/readDots.php",
		data: "",
		success: function (result) {
			
			result = result.trim();
			var points = result.split('\n');
			
			for(i=0; i<points.length; i++)
			{
				points[i] = points[i].trim();
				var point = points[i].match(/[-]?[0-9]*[.][0-9]+/g);
							
				if(i==0)
				{
					point[2] = point[2] * -1;
					z_constant = point[2];
				}
				
				pointInterpolation(points[i], points[i+1], z_constant, i+"_col");
				pointInterpolation(points[i], points[i+Math.sqrt(points.length)], z_constant, i+"_row");				
			}
			
		},
		error: function (result) {
			alert('Errore : ' + result.statusText);
		}
	});
}

function pointInterpolation(point1, point2, z_constant, i)
{
	if(!point2) return;
	
	point1 = point1.match(/[-]?[0-9]*[.][0-9]+/g);
	point2 = point2.match(/[-]?[0-9]*[.][0-9]+/g);
	
	point1[2] = point1[2] * -1;
	point2[2] = point2[2] * -1;
	
	if(point1[2] == z_constant || point2[2] == z_constant) return;
	
	middlePoint = new Array();
	middlePoint[0] = (parseFloat(point1[0])+parseFloat(point2[0]))/2;
	middlePoint[1] = (parseFloat(point1[1])+parseFloat(point2[1]))/2;
	middlePoint[2] = (parseFloat(point1[2])+parseFloat(point2[2]))/2; 
	
	color = createColor(middlePoint[2]);
	jmolScriptWait("draw middle_point_"+i+" CIRCLE {"+ middlePoint.join(" ") +"} SCALE 5 COLOR ["+color[0]+","+color[1]+","+color[2]+"];");
					
}

function createColor(z)
{
	var rgb = Array();
	var max_color = 255;
	var color_zone = 3;
	
	var color = Math.floor(z*(max_color/color_zone));
	
	if(z<0)
	{
		rgb[0] = rgb[1] = color;
		rgb[2] = max_color; 
	}
	else
	{
		rgb[0] = max_color + color;
		rgb[1] = color;
		rgb[2] = 0;
	}
	
	return rgb;
}